#import "@preview/algorithmic:1.0.0"
#import algorithmic: algorithm
#import "template.typ": conf


#show: conf.with(
  title: "Aufgabe 1: Typst-Dokument",
  teilnahme-id: "1337",

  author: (
    "Vor und Nachname"
  ),
)

*Anleitung:* Trage oben in der Konfiguration den Namen der Aufgabe, deine Teilnahme-ID, sowie deinen Vor-und Nachnamen ein. Information zu Typst findest du auf der #link("https://typst.app/docs/")[#text(fill: blue)[Typst-Website]].

= Lösungsidee

Die Idee der Lösung sollte hieraus vollkommen ersichtlich werden, ohne dass auf die eigentliche Implementierung Bezug genommen wird. Eine gute Bearbeitung sollte außerdem eine kritische Auseinandersetzung mit der Lösungsidee enthalten.

Der Text wird am besten mit Unterüberschriften strukturiert:
== Unterüberschrift

=== Unterunterüberschrift

== Mathematik

$
  a_0 & = 2 + 3 \
      & = 3^2 - 2^2
$
$
  sum_(i = 0)^3 i = product_(i = 1)^3 i = 12 / 2 = root(3, 216) 
$ <formel1>
$
  f(x) prop x^2 <=> exists r in RR : forall x in f(x) = r dot x^2 => x in cal(O)(x^2) 
$ 

Mathematische Formeln erhalten normalerweise eine Nummer, die man referenzieren kann.
Hierfür muss ein Label gesetzt werden.
In @formel1 zum Beispiel ist jeder Term gleich $6$.
Mathematische Formeln können auch im Fließtext gesetzt werden: $sum_(i=0)^3 i = product_(i=1)^3 i = 12/2 = root(3, 216).$

#pagebreak()
== Algorithmen

#algorithm({
  import algorithmic: *
  Procedure(
    "Binary-Search",
    ("A", "n", "v"),
    {
      Comment[Initialize the search range]
      Assign[$l$][$1$]
      Assign[$r$][$n$]
      LineBreak
      While(
        $l <= r$,
        {
          Assign([mid], FnInline[floor][$(l + r) / 2$])
          IfElseChain(
            $A ["mid"] < v$,
            {
              Assign[$l$][$m + 1$]
            },
            [$A ["mid"] > v$],
            {
              Assign[$r$][$m - 1$]
            },
            Return[$m$],
          )
        },
      )
      Return[*null*]
    },
  )
})

== Bilder
Bilder werden in Typst mit dem Befehl ```typ #image``` gesetzt.

#image("queue.png", width: 50%)

Um Bildunterschriften zu setzen und das bild zu zentrieren wird der Befehl ```typ #figure``` benutzt.

#figure(
  image("computerbild2.jpg", width: 50%),
  caption: "Irgendwas mit Informatik",
) <computerbild2>

Die @computerbild2 kann dann auch referenziert werden, wenn ein Label benutzt wird.

= Umsetzung

Hier wird kurz erläutert, wie die Lösungsidee im Programm tatsächlich umgesetzt wurde. Hier können auch Implementierungsdetails erwähnt werden.
= Werkzeuge
Dokumentiere alle von dir verwendeten Werkzeuge. Das können Libraries, ILP-Solver, KI (z.B. ChatGPT-5, GitHub Copilot v1.100, ...) und Ähnliches sein. Zusätzlich zur Nennung solltest du hier auch deine Vorgehensweise dokumentieren: Beschreibe, für welche Teile deiner Bearbeitung du welche Tools verwendet hast und wie du dabei vorgegangen bist (Arbeitsschritte, gemachte Anpassungen, ...).

= Beispiele
Dokumentiere alle Beispiele, die du auf den #link("https://bwinf.de/")[#text(fill: blue)[BwInf-Webseiten]] findest. Eigene Beispiele sind sehr gut – besonders wenn sie Spezialfälle abdecken. Bitte jedoch nicht 30 Seiten Programmausgabe hier einfügen! Der wichtigste Teil der Ausgabe sollte auch bei größeren Ausgaben enthalten sein. Bei sehr großen Ausgaben kann eine gekürzte Version dokumentiert und auf eine mitgeschickte Ausgabedatei verwiesen werden.

= Quellcode

Unwichtige Teile des Programms sollen hier nicht abgedruckt werden. Dieser Teil sollte nicht mehr als 2 bis 3 Seiten umfassen, maximal 10. 

Ein Rust-Programm könnte so aussehen:
#rect(
  ```rust
  fn main() {
      println!("Ein kleines Rust-Programm");
  }
  ```
)

Ein Python-Programm ohne Rahmen:
```python
for i in range(1000):
    if i % 2 == 0:
      pass
    else:
      print(i)
```

Ein Java-Programm:
#rect(
  ```java
  public class Main {
      public static void main(String[] args) {
          System.out.println("Ein kleines Java-Programm");
      }
  }
  ```
)

Ein C++-Programm:
#rect(
  ```cpp
  #include <iostream>
  int main(int argc, char** argv) {
      std::cout << "Ein kleines C++-Programm" << std::endl;
      return 0;
  }
  ```
)